//=================================================
// CozDecorationINV
//=================================================
Class CozDecorationINV extends DeusExPickup;

var class<CozDecoration> DecoClass;
var bool bIAmASofa;
var() bool bShopVersion;
var int price;

function BeginPlay()
{
	Super.BeginPlay();

	if(bShopVersion == True)
	{
		ItemName = "|p7c("$price$ItemName@")"@Itemname@".";
	}	
}

state Activated
{
	function Activate()
	{
		// can't turn it off
	}

	function BeginState()
	{
		local DeusExPlayer P;
		local CozDecoration CD;
		local vector loc;
		local rotator rot;

		loc = Owner.Location;
		rot = Owner.Rotation;
		loc += 2.0 * Owner.CollisionRadius * vector(P.ViewRotation);
		loc.Z += Owner.CollisionHeight * 0.9;

		if(bIAmASofa == true)
		{
			rot.Yaw += 16384; //Cozmo: 90 degrees. 65536 is full 360
		}
		
		Super.BeginState();

		P = DeusExPlayer(Owner);

		if(DecoClass == class'RPGMasterTest.CozDecoLamp2')
		{
			CD = Spawn(DecoClass, DeusExPlayer(Owner),, DeusExPlayer(Owner).location, DeusExPlayer(Owner).rotation);
		}
		else
		{
			CD = Spawn(DecoClass, Owner,, loc, rot);
		}

		CD.MyOwner = P;
		UseOnce();
	}
Begin:
}

auto state Pickup
{
	function Frob (Actor Frobber, Inventory frobWith)
	{
		if(bShopVersion == False)
		{
			Super.Frob(Frobber,frobWith);
			Destroy();
		}
		else
		{
			if(DeusExPlayer(Frobber).Credits >= Price)
			{
				DeusExPlayer(Frobber).Credits -= Price;
				DeusExPlayer(Frobber).ClientMessage("|p7You bought the"@default.ItemName@"for c("$price$")");
				Super.Frob(Frobber,frobWith);
			}
			else
			{
				DeusExPlayer(Frobber).ClientMessage("|p2You don't have enough money for this.");
			}
		}
	}
}

function DropFrom(vector StartLocation)
{
	ItemName=default.ItemName;
	bShopVersion = False;
	LifeSpan = 10.0;
	Super.DropFrom(StartLocation);
}

defaultproperties
{
     Lifespan=0
     bShopVersion=False
     bIAmASofa=False
     DecoClass=Class'RPGMasterTest.CozDecoration'
     maxCopies=10
     bCanHaveMultipleCopies=True
     bActivatable=True
     ItemName="Decoration"
     ItemArticle="a"
     PlayerViewOffset=(X=30.000000,Z=-22.000000)
     PlayerViewMesh=LodMesh'DeusExDeco.BoxSmall'
     PickupViewMesh=LodMesh'DeusExDeco.BoxMedium'
     ThirdPersonMesh=LodMesh'DeusExDeco.BoxSmall'
     LandSound=Sound'DeusExSounds.Generic.PaperHit2'
     Icon=Texture'DeusExUI.UserInterface.Image09_NYC_Ship_Bttm_1'
     largeIcon=Texture'DeusExUI.UserInterface.Image09_NYC_Ship_Bttm_1'
     largeIconWidth=24
     largeIconHeight=45
     Description="None set."
     beltDescription="Furniture"
     Mesh=LodMesh'DeusExDeco.BoxMedium'
     CollisionRadius=42.000000
     CollisionHeight=30.000000
     Mass=50.000000
     Mass=5.000000
     Buoyancy=3.000000
}
